/* alpm_config.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from alpm_config.vala, do not modify */

/*
 *  alpm_config
 *
 *  Copyright (C) 2014-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <alpm.h>
#include <glib-object.h>
#include <sys/utsname.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>
#include "pamac.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _AlpmRepo AlpmRepo;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define TYPE_ALPM_CONFIG (alpm_config_get_type ())
#define ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALPM_CONFIG, AlpmConfig))
#define ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALPM_CONFIG, AlpmConfigClass))
#define IS_ALPM_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALPM_CONFIG))
#define IS_ALPM_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALPM_CONFIG))
#define ALPM_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALPM_CONFIG, AlpmConfigClass))

typedef struct _AlpmConfig AlpmConfig;
typedef struct _AlpmConfigClass AlpmConfigClass;
typedef struct _AlpmConfigPrivate AlpmConfigPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alpm_release0(var) ((var == NULL) ? NULL : (var = (alpm_release (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _alpm_repo_free0(var) ((var == NULL) ? NULL : (var = (alpm_repo_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecAlpmConfig ParamSpecAlpmConfig;

struct _AlpmRepo {
	gchar* name;
	alpm_siglevel_t siglevel;
	alpm_siglevel_t siglevel_mask;
	alpm_db_usage_t usage;
	GPtrArray* urls;
};

struct _AlpmConfig {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlpmConfigPrivate * priv;
	gchar* dbpath;
	gboolean checkspace;
	GHashTable* ignorepkgs;
	GHashTable* holdpkgs;
	GHashTable* syncfirsts;
};

struct _AlpmConfigClass {
	GTypeClass parent_class;
	void (*finalize) (AlpmConfig *self);
};

struct _AlpmConfigPrivate {
	gchar* conf_path;
	gchar* rootdir;
	gchar* logfile;
	gchar* gpgdir;
	gchar* download_user;
	gboolean disable_sandbox;
	gint usesyslog;
	GPtrArray* architectures;
	GPtrArray* cachedirs;
	GPtrArray* hookdirs;
	GPtrArray* ignoregroups;
	GPtrArray* noextracts;
	GPtrArray* noupgrades;
	alpm_siglevel_t siglevel;
	alpm_siglevel_t localfilesiglevel;
	alpm_siglevel_t remotefilesiglevel;
	alpm_siglevel_t siglevel_mask;
	alpm_siglevel_t localfilesiglevel_mask;
	alpm_siglevel_t remotefilesiglevel_mask;
	GPtrArray* repo_order;
};

struct _ParamSpecAlpmConfig {
	GParamSpec parent_instance;
};

static gint AlpmConfig_private_offset;
static gpointer alpm_config_parent_class = NULL;

VALA_EXTERN void alpm_repo_free (AlpmRepo * self);
static void alpm_repo_instance_init (AlpmRepo * self);
VALA_EXTERN AlpmRepo* alpm_repo_new (const gchar* name);
static void _g_free0_ (gpointer var);
VALA_EXTERN gboolean alpm_repo_equal_name (AlpmRepo* a,
                               AlpmRepo* b);
VALA_EXTERN gpointer alpm_config_ref (gpointer instance);
VALA_EXTERN void alpm_config_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alpm_config (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_alpm_config (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_alpm_config (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_alpm_config (const GValue* value);
VALA_EXTERN GType alpm_config_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AlpmConfig* alpm_config_new (const gchar* path);
VALA_EXTERN AlpmConfig* alpm_config_construct (GType object_type,
                                   const gchar* path);
VALA_EXTERN void alpm_config_reload (AlpmConfig* self);
static void _alpm_repo_free0_ (gpointer var);
static void alpm_config_parse_file (AlpmConfig* self,
                             const gchar* path,
                             const gchar* section);
VALA_EXTERN alpm_handle_t* alpm_config_get_handle (AlpmConfig* self,
                                       gboolean files_db,
                                       gboolean tmp_db,
                                       gboolean copy_dbs);
static alpm_siglevel_t alpm_config_merge_siglevel (AlpmConfig* self,
                                            alpm_siglevel_t sigbase,
                                            alpm_siglevel_t sigover,
                                            alpm_siglevel_t sigmask);
VALA_EXTERN void alpm_config_register_syncdbs (AlpmConfig* self,
                                   alpm_handle_t* handle);
static gboolean _alpm_repo_equal_name_gequal_func (gconstpointer a,
                                            gconstpointer b);
static void alpm_config_process_siglevel (AlpmConfig* self,
                                   const gchar* conf_string,
                                   alpm_siglevel_t* siglevel,
                                   alpm_siglevel_t* siglevel_mask);
static alpm_db_usage_t alpm_config_define_usage (AlpmConfig* self,
                                          const gchar* conf_string);
VALA_EXTERN void alpm_config_write (AlpmConfig* self,
                        GHashTable* new_conf);
static GVariant* _variant_new1 (const gchar* value);
static void alpm_config_finalize (AlpmConfig * obj);
static GType alpm_config_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

AlpmRepo*
alpm_repo_new (const gchar* name)
{
	AlpmRepo* self;
	gchar* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_slice_new0 (AlpmRepo);
	alpm_repo_instance_init (self);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	self->siglevel = ALPM_SIG_USE_DEFAULT;
	self->usage = 0;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->urls);
	self->urls = _tmp1_;
	return self;
}

gboolean
alpm_repo_equal_name (AlpmRepo* a,
                      AlpmRepo* b)
{
	GEqualFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = g_str_equal;
	_tmp1_ = a->name;
	_tmp2_ = b->name;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

static void
alpm_repo_instance_init (AlpmRepo * self)
{
}

void
alpm_repo_free (AlpmRepo * self)
{
	_g_free0 (self->name);
	_g_ptr_array_unref0 (self->urls);
	g_slice_free (AlpmRepo, self);
}

static inline gpointer
alpm_config_get_instance_private (AlpmConfig* self)
{
	return G_STRUCT_MEMBER_P (self, AlpmConfig_private_offset);
}

AlpmConfig*
alpm_config_construct (GType object_type,
                       const gchar* path)
{
	AlpmConfig* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (path != NULL, NULL);
	self = (AlpmConfig*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (path);
	_g_free0 (self->priv->conf_path);
	self->priv->conf_path = _tmp0_;
	alpm_config_reload (self);
	return self;
}

AlpmConfig*
alpm_config_new (const gchar* path)
{
	return alpm_config_construct (TYPE_ALPM_CONFIG, path);
}

static void
_alpm_repo_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (alpm_repo_free (var), NULL));
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

void
alpm_config_reload (AlpmConfig* self)
{
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	GHashTable* _tmp4_;
	GPtrArray* _tmp5_;
	GPtrArray* _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	GPtrArray* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GPtrArray* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GPtrArray* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	const gchar* _tmp34_;
	GPtrArray* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	GHashTable* _tmp43_;
	gchar* _tmp44_;
	GHashTable* _tmp45_;
	gchar* _tmp46_;
	GHashTable* _tmp47_;
	gchar* _tmp48_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->architectures);
	self->priv->architectures = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->cachedirs);
	self->priv->cachedirs = _tmp1_;
	_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->hookdirs);
	self->priv->hookdirs = _tmp2_;
	_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->ignoregroups);
	self->priv->ignoregroups = _tmp3_;
	_tmp4_ = self->ignorepkgs;
	g_hash_table_remove_all (_tmp4_);
	_tmp5_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->noextracts);
	self->priv->noextracts = _tmp5_;
	_tmp6_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->noupgrades);
	self->priv->noupgrades = _tmp6_;
	_tmp7_ = self->holdpkgs;
	g_hash_table_remove_all (_tmp7_);
	_tmp8_ = self->syncfirsts;
	g_hash_table_remove_all (_tmp8_);
	self->priv->usesyslog = 0;
	self->checkspace = FALSE;
	self->priv->disable_sandbox = FALSE;
	_tmp9_ = g_strdup ("alpm");
	_g_free0 (self->priv->download_user);
	self->priv->download_user = _tmp9_;
	self->priv->siglevel = ((ALPM_SIG_PACKAGE | ALPM_SIG_PACKAGE_OPTIONAL) | ALPM_SIG_DATABASE) | ALPM_SIG_DATABASE_OPTIONAL;
	self->priv->localfilesiglevel = ALPM_SIG_USE_DEFAULT;
	self->priv->remotefilesiglevel = ALPM_SIG_USE_DEFAULT;
	_tmp10_ = g_ptr_array_new_full ((guint) 0, _alpm_repo_free0_);
	_g_ptr_array_unref0 (self->priv->repo_order);
	self->priv->repo_order = _tmp10_;
	_tmp11_ = self->priv->conf_path;
	alpm_config_parse_file (self, _tmp11_, NULL);
	_tmp12_ = self->priv->rootdir;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		const gchar* _tmp16_;
		_tmp13_ = self->dbpath;
		if (_tmp13_ == NULL) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = self->priv->rootdir;
			_tmp15_ = g_build_filename (_tmp14_, "var/lib/pacman/", NULL);
			_g_free0 (self->dbpath);
			self->dbpath = _tmp15_;
		}
		_tmp16_ = self->priv->logfile;
		if (_tmp16_ == NULL) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = self->priv->rootdir;
			_tmp18_ = g_build_filename (_tmp17_, "var/log/pacman.log", NULL);
			_g_free0 (self->priv->logfile);
			self->priv->logfile = _tmp18_;
		}
	} else {
		gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp22_;
		_tmp19_ = g_strdup ("/");
		_g_free0 (self->priv->rootdir);
		self->priv->rootdir = _tmp19_;
		_tmp20_ = self->dbpath;
		if (_tmp20_ == NULL) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("/var/lib/pacman/");
			_g_free0 (self->dbpath);
			self->dbpath = _tmp21_;
		}
		_tmp22_ = self->priv->logfile;
		if (_tmp22_ == NULL) {
			gchar* _tmp23_;
			_tmp23_ = g_strdup ("/var/log/pacman.log");
			_g_free0 (self->priv->logfile);
			self->priv->logfile = _tmp23_;
		}
	}
	_tmp24_ = self->priv->cachedirs;
	_tmp25_ = vala_g_ptr_array_get_length (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == 0) {
		GPtrArray* _tmp27_;
		gchar* _tmp28_;
		_tmp27_ = self->priv->cachedirs;
		_tmp28_ = g_strdup ("/var/cache/pacman/pkg/");
		g_ptr_array_add (_tmp27_, _tmp28_);
	}
	_tmp29_ = self->priv->hookdirs;
	_tmp30_ = vala_g_ptr_array_get_length (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == 0) {
		GPtrArray* _tmp32_;
		gchar* _tmp33_;
		_tmp32_ = self->priv->hookdirs;
		_tmp33_ = g_strdup ("/etc/pacman.d/hooks/");
		g_ptr_array_add (_tmp32_, _tmp33_);
	}
	_tmp34_ = self->priv->gpgdir;
	if (_tmp34_ == NULL) {
		gchar* _tmp35_;
		_tmp35_ = g_strdup ("/etc/pacman.d/gnupg/");
		_g_free0 (self->priv->gpgdir);
		self->priv->gpgdir = _tmp35_;
	}
	_tmp36_ = self->priv->architectures;
	_tmp37_ = vala_g_ptr_array_get_length (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ == 0) {
		GPtrArray* _tmp39_;
		struct utsname _tmp40_ = {0};
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp39_ = self->priv->architectures;
		uname (&_tmp40_);
		_tmp41_ = _tmp40_.machine;
		_tmp42_ = g_strdup (_tmp41_);
		g_ptr_array_add (_tmp39_, _tmp42_);
	}
	_tmp43_ = self->syncfirsts;
	_tmp44_ = g_strdup ("archlinux-keyring");
	g_hash_table_add (_tmp43_, _tmp44_);
	_tmp45_ = self->syncfirsts;
	_tmp46_ = g_strdup ("manjaro-keyring");
	g_hash_table_add (_tmp45_, _tmp46_);
	_tmp47_ = self->syncfirsts;
	_tmp48_ = g_strdup ("manjaro_jp-keyring");
	g_hash_table_add (_tmp47_, _tmp48_);
}

alpm_handle_t*
alpm_config_get_handle (AlpmConfig* self,
                        gboolean files_db,
                        gboolean tmp_db,
                        gboolean copy_dbs)
{
	alpm_errno_t _error_ = 0;
	alpm_handle_t* handle = NULL;
	alpm_handle_t* _tmp52_;
	alpm_handle_t* _tmp62_;
	const gchar* _tmp63_;
	alpm_handle_t* _tmp64_;
	gint _tmp65_ = 0;
	alpm_handle_t* _tmp66_;
	alpm_handle_t* _tmp67_;
	alpm_handle_t* _tmp68_;
	alpm_handle_t* _tmp69_;
	GPtrArray* _tmp70_;
	GPtrArray* _tmp73_;
	GPtrArray* _tmp76_;
	GPtrArray* _tmp79_;
	GPtrArray* _tmp82_;
	GPtrArray* _tmp85_;
	alpm_handle_t* _tmp88_;
	const gchar* _tmp89_;
	gint _tmp90_ = 0;
	alpm_handle_t* _tmp91_;
	gint _tmp92_ = 0;
	alpm_handle_t* _tmp93_;
	GError* _inner_error0_ = NULL;
	alpm_handle_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_error_ = 0;
	handle = NULL;
	if (tmp_db) {
		gchar* tmp_path = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* tmp_dbpath = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = g_get_user_name ();
		_tmp1_ = g_strdup_printf ("/tmp/pamac-%s", _tmp0_);
		tmp_path = _tmp1_;
		_tmp2_ = tmp_path;
		_tmp3_ = g_strdup_printf ("%s/dbs", _tmp2_);
		tmp_dbpath = _tmp3_;
		{
			GFile* file = NULL;
			const gchar* _tmp4_;
			GFile* _tmp5_;
			GFile* _tmp6_;
			const gchar* _tmp10_;
			GFile* _tmp11_;
			gchar* localdb_path = NULL;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* syncdb_path = NULL;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			GFile* _tmp16_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			alpm_handle_t* _tmp36_;
			_tmp4_ = tmp_path;
			_tmp5_ = g_file_new_for_path (_tmp4_);
			file = _tmp5_;
			_tmp6_ = file;
			if (!g_file_query_exists (_tmp6_, NULL)) {
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp7_ = tmp_path;
				_tmp8_ = g_strdup_printf ("mkdir -p %s", _tmp7_);
				_tmp9_ = _tmp8_;
				g_spawn_command_line_sync (_tmp9_, NULL, NULL, NULL, &_inner_error0_);
				_g_free0 (_tmp9_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					if (_inner_error0_->domain == G_SPAWN_ERROR) {
						goto __catch0_g_spawn_error;
					}
					_g_free0 (tmp_dbpath);
					_g_free0 (tmp_path);
					_alpm_release0 (handle);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp10_ = tmp_dbpath;
			_tmp11_ = g_file_new_for_path (_tmp10_);
			_g_object_unref0 (file);
			file = _tmp11_;
			_tmp12_ = self->dbpath;
			_tmp13_ = g_build_filename (_tmp12_, "local", NULL);
			localdb_path = _tmp13_;
			_tmp14_ = self->dbpath;
			_tmp15_ = g_build_filename (_tmp14_, "sync", NULL);
			syncdb_path = _tmp15_;
			_tmp16_ = file;
			if (!g_file_query_exists (_tmp16_, NULL)) {
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = tmp_dbpath;
				_tmp18_ = g_strdup_printf ("mkdir -p %s", _tmp17_);
				_tmp19_ = _tmp18_;
				g_spawn_command_line_sync (_tmp19_, NULL, NULL, NULL, &_inner_error0_);
				_g_free0 (_tmp19_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (syncdb_path);
					_g_free0 (localdb_path);
					_g_object_unref0 (file);
					if (_inner_error0_->domain == G_SPAWN_ERROR) {
						goto __catch0_g_spawn_error;
					}
					_g_free0 (tmp_dbpath);
					_g_free0 (tmp_path);
					_alpm_release0 (handle);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp20_ = localdb_path;
			_tmp21_ = tmp_dbpath;
			_tmp22_ = g_strdup_printf ("ln -sf %s %s", _tmp20_, _tmp21_);
			_tmp23_ = _tmp22_;
			g_spawn_command_line_sync (_tmp23_, NULL, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp23_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (syncdb_path);
				_g_free0 (localdb_path);
				_g_object_unref0 (file);
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				_g_free0 (tmp_dbpath);
				_g_free0 (tmp_path);
				_alpm_release0 (handle);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			if (copy_dbs) {
				const gchar* _tmp24_;
				GFile* _tmp25_;
				GFile* _tmp26_;
				_tmp24_ = syncdb_path;
				_tmp25_ = g_file_new_for_path (_tmp24_);
				_g_object_unref0 (file);
				file = _tmp25_;
				_tmp26_ = file;
				if (g_file_query_exists (_tmp26_, NULL)) {
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp27_ = syncdb_path;
					_tmp28_ = tmp_dbpath;
					_tmp29_ = g_strdup_printf ("cp --preserve=timestamps -ru %s %s", _tmp27_, _tmp28_);
					_tmp30_ = _tmp29_;
					g_spawn_command_line_sync (_tmp30_, NULL, NULL, NULL, &_inner_error0_);
					_g_free0 (_tmp30_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (syncdb_path);
						_g_free0 (localdb_path);
						_g_object_unref0 (file);
						if (_inner_error0_->domain == G_SPAWN_ERROR) {
							goto __catch0_g_spawn_error;
						}
						_g_free0 (tmp_dbpath);
						_g_free0 (tmp_path);
						_alpm_release0 (handle);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
			}
			_tmp31_ = tmp_dbpath;
			_tmp32_ = g_strdup_printf ("rm -f %s/sync/pamac_aur.db", _tmp31_);
			_tmp33_ = _tmp32_;
			g_spawn_command_line_sync (_tmp33_, NULL, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp33_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (syncdb_path);
				_g_free0 (localdb_path);
				_g_object_unref0 (file);
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				_g_free0 (tmp_dbpath);
				_g_free0 (tmp_path);
				_alpm_release0 (handle);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp34_ = self->priv->rootdir;
			_tmp35_ = tmp_dbpath;
			_tmp36_ = alpm_initialize (_tmp34_, _tmp35_, &_error_);
			_alpm_release0 (handle);
			handle = _tmp36_;
			if (_error_ == ALPM_ERR_DB_VERSION) {
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				alpm_handle_t* _tmp41_;
				{
					g_spawn_command_line_sync ("pacman-db-upgrade", NULL, NULL, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_SPAWN_ERROR) {
							goto __catch1_g_spawn_error;
						}
						_g_free0 (syncdb_path);
						_g_free0 (localdb_path);
						_g_object_unref0 (file);
						_g_free0 (tmp_dbpath);
						_g_free0 (tmp_path);
						_alpm_release0 (handle);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				goto __finally1;
				__catch1_g_spawn_error:
				{
					GError* e = NULL;
					GError* _tmp37_;
					const gchar* _tmp38_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp37_ = e;
					_tmp38_ = _tmp37_->message;
					g_warning ("alpm_config.vala:163: %s", _tmp38_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (syncdb_path);
					_g_free0 (localdb_path);
					_g_object_unref0 (file);
					if (_inner_error0_->domain == G_SPAWN_ERROR) {
						goto __catch0_g_spawn_error;
					}
					_g_free0 (tmp_dbpath);
					_g_free0 (tmp_path);
					_alpm_release0 (handle);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp39_ = self->priv->rootdir;
				_tmp40_ = tmp_dbpath;
				_tmp41_ = alpm_initialize (_tmp39_, _tmp40_, &_error_);
				_alpm_release0 (handle);
				handle = _tmp41_;
			}
			_g_free0 (syncdb_path);
			_g_free0 (localdb_path);
			_g_object_unref0 (file);
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			GError* _tmp42_;
			const gchar* _tmp43_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp42_ = e;
			_tmp43_ = _tmp42_->message;
			g_warning ("alpm_config.vala:168: %s", _tmp43_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (tmp_dbpath);
			_g_free0 (tmp_path);
			_alpm_release0 (handle);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (tmp_dbpath);
		_g_free0 (tmp_path);
	} else {
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		alpm_handle_t* _tmp46_;
		_tmp44_ = self->priv->rootdir;
		_tmp45_ = self->dbpath;
		_tmp46_ = alpm_initialize (_tmp44_, _tmp45_, &_error_);
		_alpm_release0 (handle);
		handle = _tmp46_;
		if (_error_ == ALPM_ERR_DB_VERSION) {
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			alpm_handle_t* _tmp51_;
			{
				g_spawn_command_line_sync ("pacman-db-upgrade", NULL, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_SPAWN_ERROR) {
						goto __catch2_g_spawn_error;
					}
					_alpm_release0 (handle);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			goto __finally2;
			__catch2_g_spawn_error:
			{
				GError* e = NULL;
				GError* _tmp47_;
				const gchar* _tmp48_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp47_ = e;
				_tmp48_ = _tmp47_->message;
				g_warning ("alpm_config.vala:176: %s", _tmp48_);
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_alpm_release0 (handle);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp49_ = self->priv->rootdir;
			_tmp50_ = self->dbpath;
			_tmp51_ = alpm_initialize (_tmp49_, _tmp50_, &_error_);
			_alpm_release0 (handle);
			handle = _tmp51_;
		}
	}
	_tmp52_ = handle;
	if (_tmp52_ == NULL) {
		FILE* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp53_ = stderr;
		_tmp54_ = alpm_strerror (_error_);
		_tmp55_ = g_strdup_printf (" (%s)\n", _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat ("Failed to initialize alpm library", _tmp56_, NULL);
		_tmp58_ = _tmp57_;
		fprintf (_tmp53_, "%s", _tmp58_);
		_g_free0 (_tmp58_);
		_g_free0 (_tmp56_);
		result = NULL;
		_alpm_release0 (handle);
		return result;
	}
	if (files_db) {
		alpm_handle_t* _tmp59_;
		_tmp59_ = handle;
		alpm_option_set_dbext (_tmp59_, ".files");
	}
	if (!tmp_db) {
		alpm_handle_t* _tmp60_;
		const gchar* _tmp61_;
		_tmp60_ = handle;
		_tmp61_ = self->priv->logfile;
		alpm_option_set_logfile (_tmp60_, _tmp61_);
	}
	_tmp62_ = handle;
	_tmp63_ = self->priv->gpgdir;
	alpm_option_set_gpgdir (_tmp62_, _tmp63_);
	_tmp64_ = handle;
	alpm_option_set_usesyslog (_tmp64_, self->priv->usesyslog);
	if (self->checkspace) {
		_tmp65_ = 1;
	} else {
		_tmp65_ = 0;
	}
	_tmp66_ = handle;
	alpm_option_set_checkspace (_tmp66_, _tmp65_);
	_tmp67_ = handle;
	alpm_option_set_default_siglevel (_tmp67_, (gint) self->priv->siglevel);
	self->priv->localfilesiglevel = alpm_config_merge_siglevel (self, self->priv->siglevel, self->priv->localfilesiglevel, self->priv->localfilesiglevel_mask);
	self->priv->remotefilesiglevel = alpm_config_merge_siglevel (self, self->priv->siglevel, self->priv->remotefilesiglevel, self->priv->remotefilesiglevel_mask);
	_tmp68_ = handle;
	alpm_option_set_local_file_siglevel (_tmp68_, (gint) self->priv->localfilesiglevel);
	_tmp69_ = handle;
	alpm_option_set_remote_file_siglevel (_tmp69_, (gint) self->priv->remotefilesiglevel);
	_tmp70_ = self->priv->architectures;
	{
		GPtrArray* arch_collection = NULL;
		guint arch_index = 0U;
		arch_collection = _tmp70_;
		for (arch_index = 0; arch_index < arch_collection->len; arch_index = arch_index + 1) {
			const gchar* arch = NULL;
			arch = (const gchar*) g_ptr_array_index (arch_collection, arch_index);
			{
				alpm_handle_t* _tmp71_;
				const gchar* _tmp72_;
				_tmp71_ = handle;
				_tmp72_ = arch;
				alpm_option_add_architecture (_tmp71_, _tmp72_);
			}
		}
	}
	_tmp73_ = self->priv->cachedirs;
	{
		GPtrArray* cachedir_collection = NULL;
		guint cachedir_index = 0U;
		cachedir_collection = _tmp73_;
		for (cachedir_index = 0; cachedir_index < cachedir_collection->len; cachedir_index = cachedir_index + 1) {
			const gchar* cachedir = NULL;
			cachedir = (const gchar*) g_ptr_array_index (cachedir_collection, cachedir_index);
			{
				alpm_handle_t* _tmp74_;
				const gchar* _tmp75_;
				_tmp74_ = handle;
				_tmp75_ = cachedir;
				alpm_option_add_cachedir (_tmp74_, _tmp75_);
			}
		}
	}
	_tmp76_ = self->priv->hookdirs;
	{
		GPtrArray* hookdir_collection = NULL;
		guint hookdir_index = 0U;
		hookdir_collection = _tmp76_;
		for (hookdir_index = 0; hookdir_index < hookdir_collection->len; hookdir_index = hookdir_index + 1) {
			const gchar* hookdir = NULL;
			hookdir = (const gchar*) g_ptr_array_index (hookdir_collection, hookdir_index);
			{
				alpm_handle_t* _tmp77_;
				const gchar* _tmp78_;
				_tmp77_ = handle;
				_tmp78_ = hookdir;
				alpm_option_add_hookdir (_tmp77_, _tmp78_);
			}
		}
	}
	_tmp79_ = self->priv->ignoregroups;
	{
		GPtrArray* ignoregroup_collection = NULL;
		guint ignoregroup_index = 0U;
		ignoregroup_collection = _tmp79_;
		for (ignoregroup_index = 0; ignoregroup_index < ignoregroup_collection->len; ignoregroup_index = ignoregroup_index + 1) {
			const gchar* ignoregroup = NULL;
			ignoregroup = (const gchar*) g_ptr_array_index (ignoregroup_collection, ignoregroup_index);
			{
				alpm_handle_t* _tmp80_;
				const gchar* _tmp81_;
				_tmp80_ = handle;
				_tmp81_ = ignoregroup;
				alpm_option_add_ignoregroup (_tmp80_, _tmp81_);
			}
		}
	}
	_tmp82_ = self->priv->noextracts;
	{
		GPtrArray* noextract_collection = NULL;
		guint noextract_index = 0U;
		noextract_collection = _tmp82_;
		for (noextract_index = 0; noextract_index < noextract_collection->len; noextract_index = noextract_index + 1) {
			const gchar* noextract = NULL;
			noextract = (const gchar*) g_ptr_array_index (noextract_collection, noextract_index);
			{
				alpm_handle_t* _tmp83_;
				const gchar* _tmp84_;
				_tmp83_ = handle;
				_tmp84_ = noextract;
				alpm_option_add_noextract (_tmp83_, _tmp84_);
			}
		}
	}
	_tmp85_ = self->priv->noupgrades;
	{
		GPtrArray* noupgrade_collection = NULL;
		guint noupgrade_index = 0U;
		noupgrade_collection = _tmp85_;
		for (noupgrade_index = 0; noupgrade_index < noupgrade_collection->len; noupgrade_index = noupgrade_index + 1) {
			const gchar* noupgrade = NULL;
			noupgrade = (const gchar*) g_ptr_array_index (noupgrade_collection, noupgrade_index);
			{
				alpm_handle_t* _tmp86_;
				const gchar* _tmp87_;
				_tmp86_ = handle;
				_tmp87_ = noupgrade;
				alpm_option_add_noupgrade (_tmp86_, _tmp87_);
			}
		}
	}
	_tmp88_ = handle;
	_tmp89_ = self->priv->download_user;
	alpm_option_set_sandboxuser (_tmp88_, _tmp89_);
	if (self->priv->disable_sandbox) {
		_tmp90_ = 1;
	} else {
		_tmp90_ = 0;
	}
	_tmp91_ = handle;
	alpm_option_set_disable_sandbox_filesystem (_tmp91_, _tmp90_);
	if (self->priv->disable_sandbox) {
		_tmp92_ = 1;
	} else {
		_tmp92_ = 0;
	}
	_tmp93_ = handle;
	alpm_option_set_disable_sandbox_syscalls (_tmp93_, _tmp92_);
	result = handle;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
alpm_config_register_syncdbs (AlpmConfig* self,
                              alpm_handle_t* handle)
{
	GPtrArray* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (handle != NULL);
	_tmp0_ = self->priv->repo_order;
	{
		GPtrArray* repo_collection = NULL;
		guint repo_index = 0U;
		repo_collection = _tmp0_;
		for (repo_index = 0; repo_index < repo_collection->len; repo_index = repo_index + 1) {
			AlpmRepo* repo = NULL;
			repo = (AlpmRepo*) g_ptr_array_index (repo_collection, repo_index);
			{
				AlpmRepo* _tmp1_;
				AlpmRepo* _tmp2_;
				AlpmRepo* _tmp3_;
				alpm_db_t* db = NULL;
				AlpmRepo* _tmp4_;
				const gchar* _tmp5_;
				AlpmRepo* _tmp6_;
				alpm_db_t* _tmp7_;
				AlpmRepo* _tmp8_;
				GPtrArray* _tmp9_;
				AlpmRepo* _tmp20_;
				_tmp1_ = repo;
				_tmp2_ = repo;
				_tmp3_ = repo;
				_tmp1_->siglevel = alpm_config_merge_siglevel (self, self->priv->siglevel, _tmp2_->siglevel, _tmp3_->siglevel_mask);
				_tmp4_ = repo;
				_tmp5_ = _tmp4_->name;
				_tmp6_ = repo;
				_tmp7_ = alpm_register_syncdb (handle, _tmp5_, (gint) _tmp6_->siglevel);
				db = _tmp7_;
				_tmp8_ = repo;
				_tmp9_ = _tmp8_->urls;
				{
					GPtrArray* url_collection = NULL;
					guint url_index = 0U;
					url_collection = _tmp9_;
					for (url_index = 0; url_index < url_collection->len; url_index = url_index + 1) {
						const gchar* url = NULL;
						url = (const gchar*) g_ptr_array_index (url_collection, url_index);
						{
							alpm_db_t* _tmp10_;
							const gchar* _tmp11_;
							AlpmRepo* _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							GPtrArray* _tmp16_;
							gconstpointer _tmp17_;
							gchar* _tmp18_;
							gchar* _tmp19_;
							_tmp10_ = db;
							_tmp11_ = url;
							_tmp12_ = repo;
							_tmp13_ = _tmp12_->name;
							_tmp14_ = string_replace (_tmp11_, "$repo", _tmp13_);
							_tmp15_ = _tmp14_;
							_tmp16_ = self->priv->architectures;
							_tmp17_ = g_ptr_array_index (_tmp16_, (guint) 0);
							_tmp18_ = string_replace (_tmp15_, "$arch", (const gchar*) _tmp17_);
							_tmp19_ = _tmp18_;
							alpm_db_add_server (_tmp10_, _tmp19_);
							_g_free0 (_tmp19_);
							_g_free0 (_tmp15_);
						}
					}
				}
				_tmp20_ = repo;
				if (_tmp20_->usage == 0) {
					alpm_db_t* _tmp21_;
					_tmp21_ = db;
					alpm_db_set_usage (_tmp21_, (gint) ALPM_DB_USAGE_ALL);
				} else {
					alpm_db_t* _tmp22_;
					AlpmRepo* _tmp23_;
					_tmp22_ = db;
					_tmp23_ = repo;
					alpm_db_set_usage (_tmp22_, (gint) _tmp23_->usage);
				}
			}
		}
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
_alpm_repo_equal_name_gequal_func (gconstpointer a,
                                   gconstpointer b)
{
	gboolean result;
	result = alpm_repo_equal_name ((AlpmRepo*) a, (AlpmRepo*) b);
	return result;
}

static void
alpm_config_parse_file (AlpmConfig* self,
                        const gchar* path,
                        const gchar* section)
{
	gchar* current_section = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup (section);
	current_section = _tmp0_;
	_tmp1_ = g_file_new_for_path (path);
	file = _tmp1_;
	_tmp2_ = file;
	if (g_file_query_exists (_tmp2_, NULL)) {
		{
			GFileInputStream* _tmp3_ = NULL;
			GFile* _tmp4_;
			GFileInputStream* _tmp5_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp6_;
			gchar* line = NULL;
			_tmp4_ = file;
			_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
			dis = _tmp6_;
			while (TRUE) {
				gchar* _tmp7_ = NULL;
				GDataInputStream* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gchar** splitted = NULL;
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gint splitted_length1;
				gint _splitted_size_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gboolean _tmp24_ = FALSE;
				const gchar* _tmp25_;
				const gchar* _tmp40_;
				gchar** _tmp41_;
				gchar** _tmp42_;
				const gchar* key = NULL;
				gchar** _tmp43_;
				gint _tmp43__length1;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				const gchar* val = NULL;
				gchar** _tmp46_;
				gint _tmp46__length1;
				const gchar* _tmp50_;
				const gchar* _tmp53_;
				_tmp8_ = dis;
				_tmp9_ = g_data_input_stream_read_line (_tmp8_, NULL, NULL, &_inner_error0_);
				_tmp7_ = _tmp9_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp3_);
					goto __catch0_g_error;
				}
				_tmp10_ = _tmp7_;
				_tmp7_ = NULL;
				_g_free0 (line);
				line = _tmp10_;
				_tmp11_ = line;
				if (!(_tmp11_ != NULL)) {
					_g_free0 (_tmp7_);
					break;
				}
				_tmp12_ = line;
				_tmp13_ = strlen (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == 0) {
					_g_free0 (_tmp7_);
					continue;
				}
				_tmp15_ = line;
				_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "#", 2);
				splitted = _tmp17_;
				splitted_length1 = _vala_array_length (_tmp16_);
				_splitted_size_ = splitted_length1;
				_tmp18_ = splitted;
				_tmp18__length1 = splitted_length1;
				_tmp19_ = _tmp18_[0];
				_tmp20_ = string_strip (_tmp19_);
				_g_free0 (line);
				line = _tmp20_;
				_tmp21_ = line;
				_tmp22_ = strlen (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_ == 0) {
					splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp7_);
					continue;
				}
				_tmp25_ = line;
				if (string_get (_tmp25_, (glong) 0) == '[') {
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp26_ = line;
					_tmp27_ = line;
					_tmp28_ = strlen (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp24_ = string_get (_tmp26_, (glong) (_tmp29_ - 1)) == ']';
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					const gchar* _tmp30_;
					gchar* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp30_ = line;
					_tmp31_ = string_slice (_tmp30_, (glong) 1, (glong) -1);
					_g_free0 (current_section);
					current_section = _tmp31_;
					_tmp32_ = current_section;
					if (_tmp32_ == NULL) {
						splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp7_);
						continue;
					}
					_tmp33_ = current_section;
					if (g_strcmp0 (_tmp33_, "options") != 0) {
						AlpmRepo* repo = NULL;
						const gchar* _tmp34_;
						AlpmRepo* _tmp35_;
						GPtrArray* _tmp36_;
						AlpmRepo* _tmp37_;
						_tmp34_ = current_section;
						_tmp35_ = alpm_repo_new (_tmp34_);
						repo = _tmp35_;
						_tmp36_ = self->priv->repo_order;
						_tmp37_ = repo;
						if (!g_ptr_array_find_with_equal_func (_tmp36_, _tmp37_, _alpm_repo_equal_name_gequal_func, NULL)) {
							GPtrArray* _tmp38_;
							AlpmRepo* _tmp39_;
							_tmp38_ = self->priv->repo_order;
							_tmp39_ = repo;
							repo = NULL;
							g_ptr_array_add (_tmp38_, _tmp39_);
						}
						_alpm_repo_free0 (repo);
					}
					splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp7_);
					continue;
				}
				_tmp40_ = line;
				_tmp42_ = _tmp41_ = g_strsplit (_tmp40_, "=", 2);
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				splitted = _tmp42_;
				splitted_length1 = _vala_array_length (_tmp41_);
				_splitted_size_ = splitted_length1;
				_tmp43_ = splitted;
				_tmp43__length1 = splitted_length1;
				_tmp44_ = _tmp43_[0];
				_tmp45_ = g_strstrip (_tmp44_);
				key = _tmp45_;
				val = NULL;
				_tmp46_ = splitted;
				_tmp46__length1 = splitted_length1;
				if (_tmp46__length1 == 2) {
					gchar** _tmp47_;
					gint _tmp47__length1;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					_tmp47_ = splitted;
					_tmp47__length1 = splitted_length1;
					_tmp48_ = _tmp47_[1];
					_tmp49_ = g_strstrip (_tmp48_);
					val = _tmp49_;
				}
				_tmp50_ = key;
				if (g_strcmp0 (_tmp50_, "Include") == 0) {
					const gchar* _tmp51_;
					const gchar* _tmp52_;
					_tmp51_ = val;
					_tmp52_ = current_section;
					alpm_config_parse_file (self, _tmp51_, _tmp52_);
				}
				_tmp53_ = current_section;
				if (g_strcmp0 (_tmp53_, "options") == 0) {
					const gchar* _tmp54_;
					_tmp54_ = key;
					if (g_strcmp0 (_tmp54_, "RootDir") == 0) {
						const gchar* _tmp55_;
						gchar* _tmp56_;
						_tmp55_ = val;
						_tmp56_ = g_strdup (_tmp55_);
						_g_free0 (self->priv->rootdir);
						self->priv->rootdir = _tmp56_;
					} else {
						const gchar* _tmp57_;
						_tmp57_ = key;
						if (g_strcmp0 (_tmp57_, "DBPath") == 0) {
							const gchar* _tmp58_;
							gchar* _tmp59_;
							_tmp58_ = val;
							_tmp59_ = g_strdup (_tmp58_);
							_g_free0 (self->dbpath);
							self->dbpath = _tmp59_;
						} else {
							const gchar* _tmp60_;
							_tmp60_ = key;
							if (g_strcmp0 (_tmp60_, "CacheDir") == 0) {
								const gchar* _tmp61_;
								gchar** _tmp62_;
								gchar** _tmp63_;
								_tmp61_ = val;
								_tmp63_ = _tmp62_ = g_strsplit (_tmp61_, " ", 0);
								{
									gchar** dir_collection = NULL;
									gint dir_collection_length1 = 0;
									gint _dir_collection_size_ = 0;
									gint dir_it = 0;
									dir_collection = _tmp63_;
									dir_collection_length1 = _vala_array_length (_tmp62_);
									for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
										const gchar* dir = NULL;
										dir = dir_collection[dir_it];
										{
											GPtrArray* _tmp64_;
											const gchar* _tmp65_;
											gchar* _tmp66_;
											_tmp64_ = self->priv->cachedirs;
											_tmp65_ = dir;
											_tmp66_ = g_strdup (_tmp65_);
											g_ptr_array_add (_tmp64_, _tmp66_);
										}
									}
									dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
								}
							} else {
								const gchar* _tmp67_;
								_tmp67_ = key;
								if (g_strcmp0 (_tmp67_, "HookDir") == 0) {
									const gchar* _tmp68_;
									gchar** _tmp69_;
									gchar** _tmp70_;
									_tmp68_ = val;
									_tmp70_ = _tmp69_ = g_strsplit (_tmp68_, " ", 0);
									{
										gchar** dir_collection = NULL;
										gint dir_collection_length1 = 0;
										gint _dir_collection_size_ = 0;
										gint dir_it = 0;
										dir_collection = _tmp70_;
										dir_collection_length1 = _vala_array_length (_tmp69_);
										for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
											const gchar* dir = NULL;
											dir = dir_collection[dir_it];
											{
												GPtrArray* _tmp71_;
												const gchar* _tmp72_;
												gchar* _tmp73_;
												_tmp71_ = self->priv->hookdirs;
												_tmp72_ = dir;
												_tmp73_ = g_strdup (_tmp72_);
												g_ptr_array_add (_tmp71_, _tmp73_);
											}
										}
										dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
									}
								} else {
									const gchar* _tmp74_;
									_tmp74_ = key;
									if (g_strcmp0 (_tmp74_, "LogFile") == 0) {
										const gchar* _tmp75_;
										gchar* _tmp76_;
										_tmp75_ = val;
										_tmp76_ = g_strdup (_tmp75_);
										_g_free0 (self->priv->logfile);
										self->priv->logfile = _tmp76_;
									} else {
										const gchar* _tmp77_;
										_tmp77_ = key;
										if (g_strcmp0 (_tmp77_, "GPGDir") == 0) {
											const gchar* _tmp78_;
											gchar* _tmp79_;
											_tmp78_ = val;
											_tmp79_ = g_strdup (_tmp78_);
											_g_free0 (self->priv->gpgdir);
											self->priv->gpgdir = _tmp79_;
										} else {
											const gchar* _tmp80_;
											_tmp80_ = key;
											if (g_strcmp0 (_tmp80_, "LogFile") == 0) {
												const gchar* _tmp81_;
												gchar* _tmp82_;
												_tmp81_ = val;
												_tmp82_ = g_strdup (_tmp81_);
												_g_free0 (self->priv->logfile);
												self->priv->logfile = _tmp82_;
											} else {
												const gchar* _tmp83_;
												_tmp83_ = key;
												if (g_strcmp0 (_tmp83_, "Architecture") == 0) {
													const gchar* _tmp84_;
													gchar** _tmp85_;
													gchar** _tmp86_;
													_tmp84_ = val;
													_tmp86_ = _tmp85_ = g_strsplit (_tmp84_, " ", 0);
													{
														gchar** arch_collection = NULL;
														gint arch_collection_length1 = 0;
														gint _arch_collection_size_ = 0;
														gint arch_it = 0;
														arch_collection = _tmp86_;
														arch_collection_length1 = _vala_array_length (_tmp85_);
														for (arch_it = 0; arch_it < arch_collection_length1; arch_it = arch_it + 1) {
															const gchar* arch = NULL;
															arch = arch_collection[arch_it];
															{
																const gchar* _tmp87_;
																_tmp87_ = arch;
																if (g_strcmp0 (_tmp87_, "auto") == 0) {
																	GPtrArray* _tmp88_;
																	struct utsname _tmp89_ = {0};
																	const gchar* _tmp90_;
																	gchar* _tmp91_;
																	_tmp88_ = self->priv->architectures;
																	uname (&_tmp89_);
																	_tmp90_ = _tmp89_.machine;
																	_tmp91_ = g_strdup (_tmp90_);
																	g_ptr_array_add (_tmp88_, _tmp91_);
																} else {
																	GPtrArray* _tmp92_;
																	const gchar* _tmp93_;
																	gchar* _tmp94_;
																	_tmp92_ = self->priv->architectures;
																	_tmp93_ = arch;
																	_tmp94_ = g_strdup (_tmp93_);
																	g_ptr_array_add (_tmp92_, _tmp94_);
																}
															}
														}
														arch_collection = (_vala_array_free (arch_collection, arch_collection_length1, (GDestroyNotify) g_free), NULL);
													}
												} else {
													const gchar* _tmp95_;
													_tmp95_ = key;
													if (g_strcmp0 (_tmp95_, "UseSysLog") == 0) {
														self->priv->usesyslog = 1;
													} else {
														const gchar* _tmp96_;
														_tmp96_ = key;
														if (g_strcmp0 (_tmp96_, "CheckSpace") == 0) {
															self->checkspace = TRUE;
														} else {
															const gchar* _tmp97_;
															_tmp97_ = key;
															if (g_strcmp0 (_tmp97_, "SigLevel") == 0) {
																const gchar* _tmp98_;
																_tmp98_ = val;
																alpm_config_process_siglevel (self, _tmp98_, &self->priv->siglevel, &self->priv->siglevel_mask);
															} else {
																const gchar* _tmp99_;
																_tmp99_ = key;
																if (g_strcmp0 (_tmp99_, "LocalFileSigLevel") == 0) {
																	const gchar* _tmp100_;
																	_tmp100_ = val;
																	alpm_config_process_siglevel (self, _tmp100_, &self->priv->localfilesiglevel, &self->priv->localfilesiglevel_mask);
																} else {
																	const gchar* _tmp101_;
																	_tmp101_ = key;
																	if (g_strcmp0 (_tmp101_, "RemoteFileSigLevel") == 0) {
																		const gchar* _tmp102_;
																		_tmp102_ = val;
																		alpm_config_process_siglevel (self, _tmp102_, &self->priv->remotefilesiglevel, &self->priv->remotefilesiglevel_mask);
																	} else {
																		const gchar* _tmp103_;
																		_tmp103_ = key;
																		if (g_strcmp0 (_tmp103_, "HoldPkg") == 0) {
																			const gchar* _tmp104_;
																			gchar** _tmp105_;
																			gchar** _tmp106_;
																			_tmp104_ = val;
																			_tmp106_ = _tmp105_ = g_strsplit (_tmp104_, " ", 0);
																			{
																				gchar** name_collection = NULL;
																				gint name_collection_length1 = 0;
																				gint _name_collection_size_ = 0;
																				gint name_it = 0;
																				name_collection = _tmp106_;
																				name_collection_length1 = _vala_array_length (_tmp105_);
																				for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
																					const gchar* name = NULL;
																					name = name_collection[name_it];
																					{
																						GHashTable* _tmp107_;
																						const gchar* _tmp108_;
																						gchar* _tmp109_;
																						_tmp107_ = self->holdpkgs;
																						_tmp108_ = name;
																						_tmp109_ = g_strdup (_tmp108_);
																						g_hash_table_add (_tmp107_, _tmp109_);
																					}
																				}
																				name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
																			}
																		} else {
																			const gchar* _tmp110_;
																			_tmp110_ = key;
																			if (g_strcmp0 (_tmp110_, "SyncFirst") == 0) {
																				const gchar* _tmp111_;
																				gchar** _tmp112_;
																				gchar** _tmp113_;
																				_tmp111_ = val;
																				_tmp113_ = _tmp112_ = g_strsplit (_tmp111_, " ", 0);
																				{
																					gchar** name_collection = NULL;
																					gint name_collection_length1 = 0;
																					gint _name_collection_size_ = 0;
																					gint name_it = 0;
																					name_collection = _tmp113_;
																					name_collection_length1 = _vala_array_length (_tmp112_);
																					for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
																						const gchar* name = NULL;
																						name = name_collection[name_it];
																						{
																							GHashTable* _tmp114_;
																							const gchar* _tmp115_;
																							gchar* _tmp116_;
																							_tmp114_ = self->syncfirsts;
																							_tmp115_ = name;
																							_tmp116_ = g_strdup (_tmp115_);
																							g_hash_table_add (_tmp114_, _tmp116_);
																						}
																					}
																					name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
																				}
																			} else {
																				const gchar* _tmp117_;
																				_tmp117_ = key;
																				if (g_strcmp0 (_tmp117_, "IgnoreGroup") == 0) {
																					const gchar* _tmp118_;
																					gchar** _tmp119_;
																					gchar** _tmp120_;
																					_tmp118_ = val;
																					_tmp120_ = _tmp119_ = g_strsplit (_tmp118_, " ", 0);
																					{
																						gchar** name_collection = NULL;
																						gint name_collection_length1 = 0;
																						gint _name_collection_size_ = 0;
																						gint name_it = 0;
																						name_collection = _tmp120_;
																						name_collection_length1 = _vala_array_length (_tmp119_);
																						for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
																							const gchar* name = NULL;
																							name = name_collection[name_it];
																							{
																								GPtrArray* _tmp121_;
																								const gchar* _tmp122_;
																								gchar* _tmp123_;
																								_tmp121_ = self->priv->ignoregroups;
																								_tmp122_ = name;
																								_tmp123_ = g_strdup (_tmp122_);
																								g_ptr_array_add (_tmp121_, _tmp123_);
																							}
																						}
																						name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
																					}
																				} else {
																					const gchar* _tmp124_;
																					_tmp124_ = key;
																					if (g_strcmp0 (_tmp124_, "IgnorePkg") == 0) {
																						const gchar* _tmp125_;
																						gchar** _tmp126_;
																						gchar** _tmp127_;
																						_tmp125_ = val;
																						_tmp127_ = _tmp126_ = g_strsplit (_tmp125_, " ", 0);
																						{
																							gchar** name_collection = NULL;
																							gint name_collection_length1 = 0;
																							gint _name_collection_size_ = 0;
																							gint name_it = 0;
																							name_collection = _tmp127_;
																							name_collection_length1 = _vala_array_length (_tmp126_);
																							for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
																								const gchar* name = NULL;
																								name = name_collection[name_it];
																								{
																									GHashTable* _tmp128_;
																									const gchar* _tmp129_;
																									gchar* _tmp130_;
																									_tmp128_ = self->ignorepkgs;
																									_tmp129_ = name;
																									_tmp130_ = g_strdup (_tmp129_);
																									g_hash_table_add (_tmp128_, _tmp130_);
																								}
																							}
																							name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
																						}
																					} else {
																						const gchar* _tmp131_;
																						_tmp131_ = key;
																						if (g_strcmp0 (_tmp131_, "NoExtract") == 0) {
																							const gchar* _tmp132_;
																							gchar** _tmp133_;
																							gchar** _tmp134_;
																							_tmp132_ = val;
																							_tmp134_ = _tmp133_ = g_strsplit (_tmp132_, " ", 0);
																							{
																								gchar** name_collection = NULL;
																								gint name_collection_length1 = 0;
																								gint _name_collection_size_ = 0;
																								gint name_it = 0;
																								name_collection = _tmp134_;
																								name_collection_length1 = _vala_array_length (_tmp133_);
																								for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
																									const gchar* name = NULL;
																									name = name_collection[name_it];
																									{
																										GPtrArray* _tmp135_;
																										const gchar* _tmp136_;
																										gchar* _tmp137_;
																										_tmp135_ = self->priv->noextracts;
																										_tmp136_ = name;
																										_tmp137_ = g_strdup (_tmp136_);
																										g_ptr_array_add (_tmp135_, _tmp137_);
																									}
																								}
																								name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
																							}
																						} else {
																							const gchar* _tmp138_;
																							_tmp138_ = key;
																							if (g_strcmp0 (_tmp138_, "NoUpgrade") == 0) {
																								const gchar* _tmp139_;
																								gchar** _tmp140_;
																								gchar** _tmp141_;
																								_tmp139_ = val;
																								_tmp141_ = _tmp140_ = g_strsplit (_tmp139_, " ", 0);
																								{
																									gchar** name_collection = NULL;
																									gint name_collection_length1 = 0;
																									gint _name_collection_size_ = 0;
																									gint name_it = 0;
																									name_collection = _tmp141_;
																									name_collection_length1 = _vala_array_length (_tmp140_);
																									for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
																										const gchar* name = NULL;
																										name = name_collection[name_it];
																										{
																											GPtrArray* _tmp142_;
																											const gchar* _tmp143_;
																											gchar* _tmp144_;
																											_tmp142_ = self->priv->noupgrades;
																											_tmp143_ = name;
																											_tmp144_ = g_strdup (_tmp143_);
																											g_ptr_array_add (_tmp142_, _tmp144_);
																										}
																									}
																									name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
																								}
																							} else {
																								const gchar* _tmp145_;
																								_tmp145_ = key;
																								if (g_strcmp0 (_tmp145_, "DownloadUser") == 0) {
																									const gchar* _tmp146_;
																									gchar* _tmp147_;
																									_tmp146_ = val;
																									_tmp147_ = g_strdup (_tmp146_);
																									_g_free0 (self->priv->download_user);
																									self->priv->download_user = _tmp147_;
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					GPtrArray* _tmp148_;
					_tmp148_ = self->priv->repo_order;
					{
						GPtrArray* repo_collection = NULL;
						guint repo_index = 0U;
						repo_collection = _tmp148_;
						for (repo_index = 0; repo_index < repo_collection->len; repo_index = repo_index + 1) {
							AlpmRepo* repo = NULL;
							repo = (AlpmRepo*) g_ptr_array_index (repo_collection, repo_index);
							{
								AlpmRepo* _tmp149_;
								const gchar* _tmp150_;
								const gchar* _tmp151_;
								_tmp149_ = repo;
								_tmp150_ = _tmp149_->name;
								_tmp151_ = current_section;
								if (g_strcmp0 (_tmp150_, _tmp151_) == 0) {
									const gchar* _tmp152_;
									_tmp152_ = key;
									if (g_strcmp0 (_tmp152_, "Server") == 0) {
										AlpmRepo* _tmp153_;
										GPtrArray* _tmp154_;
										const gchar* _tmp155_;
										gchar* _tmp156_;
										_tmp153_ = repo;
										_tmp154_ = _tmp153_->urls;
										_tmp155_ = val;
										_tmp156_ = g_strdup (_tmp155_);
										g_ptr_array_add (_tmp154_, _tmp156_);
									} else {
										const gchar* _tmp157_;
										_tmp157_ = key;
										if (g_strcmp0 (_tmp157_, "SigLevel") == 0) {
											const gchar* _tmp158_;
											AlpmRepo* _tmp159_;
											AlpmRepo* _tmp160_;
											_tmp158_ = val;
											_tmp159_ = repo;
											_tmp160_ = repo;
											alpm_config_process_siglevel (self, _tmp158_, &_tmp159_->siglevel, &_tmp160_->siglevel_mask);
										} else {
											const gchar* _tmp161_;
											_tmp161_ = key;
											if (g_strcmp0 (_tmp161_, "Usage") == 0) {
												AlpmRepo* _tmp162_;
												const gchar* _tmp163_;
												_tmp162_ = repo;
												_tmp163_ = val;
												_tmp162_->usage = alpm_config_define_usage (self, _tmp163_);
											}
										}
									}
									break;
								}
							}
						}
					}
				}
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_tmp7_);
			}
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp164_;
			const gchar* _tmp165_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp164_ = e;
			_tmp165_ = _tmp164_->message;
			g_warning ("alpm_config.vala:363: %s", _tmp165_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (current_section);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		g_warning ("alpm_config.vala:366: File '%s' doesn't exist", path);
	}
	_g_object_unref0 (file);
	_g_free0 (current_section);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

void
alpm_config_write (AlpmConfig* self,
                   GHashTable* new_conf)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_conf != NULL);
	_tmp0_ = self->priv->conf_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	if (g_file_query_exists (_tmp2_, NULL)) {
		{
			GFileInputStream* _tmp3_ = NULL;
			GFile* _tmp4_;
			GFileInputStream* _tmp5_;
			GDataInputStream* dis = NULL;
			GDataInputStream* _tmp6_;
			gchar* line = NULL;
			GString* data = NULL;
			GString* _tmp7_;
			GFile* _tmp42_;
			GFileOutputStream* _tmp43_ = NULL;
			GFile* _tmp44_;
			GFileOutputStream* _tmp45_;
			GDataOutputStream* dos = NULL;
			GDataOutputStream* _tmp46_;
			GDataOutputStream* _tmp47_;
			GString* _tmp48_;
			const gchar* _tmp49_;
			_tmp4_ = file;
			_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
			dis = _tmp6_;
			_tmp7_ = g_string_new ("");
			data = _tmp7_;
			while (TRUE) {
				gchar* _tmp8_ = NULL;
				GDataInputStream* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				const gchar* _tmp17_;
				_tmp9_ = dis;
				_tmp10_ = g_data_input_stream_read_line (_tmp9_, NULL, NULL, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_string_free0 (data);
					_g_free0 (line);
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp3_);
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_free0 (line);
				line = _tmp11_;
				_tmp12_ = line;
				if (!(_tmp12_ != NULL)) {
					_g_free0 (_tmp8_);
					break;
				}
				_tmp13_ = line;
				_tmp14_ = strlen (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == 0) {
					GString* _tmp16_;
					_tmp16_ = data;
					g_string_append (_tmp16_, "\n");
					_g_free0 (_tmp8_);
					continue;
				}
				_tmp17_ = line;
				if (string_contains (_tmp17_, "IgnorePkg")) {
					if (g_hash_table_contains (new_conf, "IgnorePkg")) {
						gchar* val = NULL;
						gconstpointer _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						const gchar* _tmp21_;
						gchar* _tmp27_;
						GVariant* _tmp28_;
						_tmp18_ = g_hash_table_lookup (new_conf, "IgnorePkg");
						_tmp19_ = g_variant_get_string ((GVariant*) _tmp18_, NULL);
						_tmp20_ = g_strdup (_tmp19_);
						val = _tmp20_;
						_tmp21_ = val;
						if (g_strcmp0 (_tmp21_, "") == 0) {
							GString* _tmp22_;
							_tmp22_ = data;
							g_string_append (_tmp22_, "#IgnorePkg   =\n");
						} else {
							GString* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
							_tmp23_ = data;
							_tmp24_ = val;
							_tmp25_ = g_strdup_printf ("IgnorePkg   = %s\n", _tmp24_);
							_tmp26_ = _tmp25_;
							g_string_append (_tmp23_, _tmp26_);
							_g_free0 (_tmp26_);
						}
						_tmp27_ = g_strdup ("IgnorePkg");
						_tmp28_ = _variant_new1 ("");
						g_hash_table_replace (new_conf, _tmp27_, _tmp28_);
						_g_free0 (val);
					} else {
						GString* _tmp29_;
						const gchar* _tmp30_;
						GString* _tmp31_;
						_tmp29_ = data;
						_tmp30_ = line;
						g_string_append (_tmp29_, _tmp30_);
						_tmp31_ = data;
						g_string_append (_tmp31_, "\n");
					}
				} else {
					const gchar* _tmp32_;
					_tmp32_ = line;
					if (string_contains (_tmp32_, "CheckSpace")) {
						if (g_hash_table_contains (new_conf, "CheckSpace")) {
							gboolean val = FALSE;
							gconstpointer _tmp33_;
							_tmp33_ = g_hash_table_lookup (new_conf, "CheckSpace");
							val = g_variant_get_boolean ((GVariant*) _tmp33_);
							if (val) {
								GString* _tmp34_;
								_tmp34_ = data;
								g_string_append (_tmp34_, "CheckSpace\n");
							} else {
								GString* _tmp35_;
								_tmp35_ = data;
								g_string_append (_tmp35_, "#CheckSpace\n");
							}
							g_hash_table_remove (new_conf, "CheckSpace");
						} else {
							GString* _tmp36_;
							const gchar* _tmp37_;
							GString* _tmp38_;
							_tmp36_ = data;
							_tmp37_ = line;
							g_string_append (_tmp36_, _tmp37_);
							_tmp38_ = data;
							g_string_append (_tmp38_, "\n");
						}
					} else {
						GString* _tmp39_;
						const gchar* _tmp40_;
						GString* _tmp41_;
						_tmp39_ = data;
						_tmp40_ = line;
						g_string_append (_tmp39_, _tmp40_);
						_tmp41_ = data;
						g_string_append (_tmp41_, "\n");
					}
				}
				_g_free0 (_tmp8_);
			}
			_tmp42_ = file;
			g_file_delete (_tmp42_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_string_free0 (data);
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp3_);
				goto __catch0_g_error;
			}
			_tmp44_ = file;
			_tmp45_ = g_file_create (_tmp44_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
			_tmp43_ = _tmp45_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_string_free0 (data);
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp3_);
				goto __catch0_g_error;
			}
			_tmp46_ = g_data_output_stream_new ((GOutputStream*) _tmp43_);
			dos = _tmp46_;
			_tmp47_ = dos;
			_tmp48_ = data;
			_tmp49_ = _tmp48_->str;
			g_data_output_stream_put_string (_tmp47_, _tmp49_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dos);
				_g_object_unref0 (_tmp43_);
				_g_string_free0 (data);
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp3_);
				goto __catch0_g_error;
			}
			_g_object_unref0 (dos);
			_g_object_unref0 (_tmp43_);
			_g_string_free0 (data);
			_g_free0 (line);
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp50_;
			const gchar* _tmp51_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp50_ = e;
			_tmp51_ = _tmp50_->message;
			g_warning ("alpm_config.vala:423: %s", _tmp51_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		const gchar* _tmp52_;
		_tmp52_ = self->priv->conf_path;
		g_warning ("alpm_config.vala:426: File '%s' doesn't exist.", _tmp52_);
	}
	_g_object_unref0 (file);
}

static alpm_db_usage_t
alpm_config_define_usage (AlpmConfig* self,
                          const gchar* conf_string)
{
	alpm_db_usage_t usage = 0;
	gchar** _tmp0_;
	gchar** _tmp1_;
	alpm_db_usage_t result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (conf_string != NULL, 0);
	usage = 0;
	_tmp1_ = _tmp0_ = g_strsplit (conf_string, " ", 0);
	{
		gchar** directive_collection = NULL;
		gint directive_collection_length1 = 0;
		gint _directive_collection_size_ = 0;
		gint directive_it = 0;
		directive_collection = _tmp1_;
		directive_collection_length1 = _vala_array_length (_tmp0_);
		for (directive_it = 0; directive_it < directive_collection_length1; directive_it = directive_it + 1) {
			const gchar* directive = NULL;
			directive = directive_collection[directive_it];
			{
				const gchar* _tmp2_;
				_tmp2_ = directive;
				if (g_strcmp0 (_tmp2_, "Sync") == 0) {
					usage |= ALPM_DB_USAGE_SYNC;
				} else {
					const gchar* _tmp3_;
					_tmp3_ = directive;
					if (g_strcmp0 (_tmp3_, "Search") == 0) {
						usage |= ALPM_DB_USAGE_SEARCH;
					} else {
						const gchar* _tmp4_;
						_tmp4_ = directive;
						if (g_strcmp0 (_tmp4_, "Install") == 0) {
							usage |= ALPM_DB_USAGE_INSTALL;
						} else {
							const gchar* _tmp5_;
							_tmp5_ = directive;
							if (g_strcmp0 (_tmp5_, "Upgrade") == 0) {
								usage |= ALPM_DB_USAGE_UPGRADE;
							} else {
								const gchar* _tmp6_;
								_tmp6_ = directive;
								if (g_strcmp0 (_tmp6_, "All") == 0) {
									usage |= ALPM_DB_USAGE_ALL;
								}
							}
						}
					}
				}
			}
		}
		directive_collection = (_vala_array_free (directive_collection, directive_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = usage;
	return result;
}

static void
alpm_config_process_siglevel (AlpmConfig* self,
                              const gchar* conf_string,
                              alpm_siglevel_t* siglevel,
                              alpm_siglevel_t* siglevel_mask)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conf_string != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (conf_string, " ", 0);
	{
		gchar** directive_collection = NULL;
		gint directive_collection_length1 = 0;
		gint _directive_collection_size_ = 0;
		gint directive_it = 0;
		directive_collection = _tmp1_;
		directive_collection_length1 = _vala_array_length (_tmp0_);
		for (directive_it = 0; directive_it < directive_collection_length1; directive_it = directive_it + 1) {
			const gchar* directive = NULL;
			directive = directive_collection[directive_it];
			{
				gboolean affect_package = FALSE;
				gboolean affect_database = FALSE;
				const gchar* _tmp2_;
				const gchar* _tmp4_;
				affect_package = FALSE;
				affect_database = FALSE;
				_tmp2_ = directive;
				if (string_contains (_tmp2_, "Package")) {
					affect_package = TRUE;
				} else {
					const gchar* _tmp3_;
					_tmp3_ = directive;
					if (string_contains (_tmp3_, "Database")) {
						affect_database = TRUE;
					} else {
						affect_package = TRUE;
						affect_database = TRUE;
					}
				}
				_tmp4_ = directive;
				if (string_contains (_tmp4_, "Never")) {
					if (affect_package) {
						*siglevel = (*siglevel) & (~ALPM_SIG_PACKAGE);
						*siglevel_mask = (*siglevel_mask) | ALPM_SIG_PACKAGE;
					}
					if (affect_database) {
						*siglevel = (*siglevel) & (~ALPM_SIG_DATABASE);
						*siglevel_mask = (*siglevel_mask) | ALPM_SIG_DATABASE;
					}
				} else {
					const gchar* _tmp5_;
					_tmp5_ = directive;
					if (string_contains (_tmp5_, "Optional")) {
						if (affect_package) {
							*siglevel = (*siglevel) | (ALPM_SIG_PACKAGE | ALPM_SIG_PACKAGE_OPTIONAL);
							*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_PACKAGE | ALPM_SIG_PACKAGE_OPTIONAL);
						}
						if (affect_database) {
							*siglevel = (*siglevel) | (ALPM_SIG_DATABASE | ALPM_SIG_DATABASE_OPTIONAL);
							*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_DATABASE | ALPM_SIG_DATABASE_OPTIONAL);
						}
					} else {
						const gchar* _tmp6_;
						_tmp6_ = directive;
						if (string_contains (_tmp6_, "Required")) {
							if (affect_package) {
								*siglevel = (*siglevel) | ALPM_SIG_PACKAGE;
								*siglevel_mask = (*siglevel_mask) | ALPM_SIG_PACKAGE;
								*siglevel = (*siglevel) & (~ALPM_SIG_PACKAGE_OPTIONAL);
								*siglevel_mask = (*siglevel_mask) | ALPM_SIG_PACKAGE_OPTIONAL;
							}
							if (affect_database) {
								*siglevel = (*siglevel) | ALPM_SIG_DATABASE;
								*siglevel_mask = (*siglevel_mask) | ALPM_SIG_DATABASE;
								*siglevel = (*siglevel) & (~ALPM_SIG_DATABASE_OPTIONAL);
								*siglevel_mask = (*siglevel_mask) | ALPM_SIG_DATABASE_OPTIONAL;
							}
						} else {
							const gchar* _tmp7_;
							_tmp7_ = directive;
							if (string_contains (_tmp7_, "TrustedOnly")) {
								if (affect_package) {
									*siglevel = (*siglevel) & (~(ALPM_SIG_PACKAGE_MARGINAL_OK | ALPM_SIG_PACKAGE_UNKNOWN_OK));
									*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_PACKAGE_MARGINAL_OK | ALPM_SIG_PACKAGE_UNKNOWN_OK);
								}
								if (affect_database) {
									*siglevel = (*siglevel) & (~(ALPM_SIG_DATABASE_MARGINAL_OK | ALPM_SIG_DATABASE_UNKNOWN_OK));
									*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_DATABASE_MARGINAL_OK | ALPM_SIG_DATABASE_UNKNOWN_OK);
								}
							} else {
								const gchar* _tmp8_;
								_tmp8_ = directive;
								if (string_contains (_tmp8_, "TrustAll")) {
									if (affect_package) {
										*siglevel = (*siglevel) | (ALPM_SIG_PACKAGE_MARGINAL_OK | ALPM_SIG_PACKAGE_UNKNOWN_OK);
										*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_PACKAGE_MARGINAL_OK | ALPM_SIG_PACKAGE_UNKNOWN_OK);
									}
									if (affect_database) {
										*siglevel = (*siglevel) | (ALPM_SIG_DATABASE_MARGINAL_OK | ALPM_SIG_DATABASE_UNKNOWN_OK);
										*siglevel_mask = (*siglevel_mask) | (ALPM_SIG_DATABASE_MARGINAL_OK | ALPM_SIG_DATABASE_UNKNOWN_OK);
									}
								} else {
									FILE* _tmp9_;
									_tmp9_ = stderr;
									fprintf (_tmp9_, "unrecognized siglevel: %s\n", conf_string);
								}
							}
						}
					}
				}
			}
		}
		directive_collection = (_vala_array_free (directive_collection, directive_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	*siglevel = (*siglevel) & (~ALPM_SIG_USE_DEFAULT);
}

static alpm_siglevel_t
alpm_config_merge_siglevel (AlpmConfig* self,
                            alpm_siglevel_t sigbase,
                            alpm_siglevel_t sigover,
                            alpm_siglevel_t sigmask)
{
	alpm_siglevel_t _tmp0_ = 0;
	alpm_siglevel_t result;
	g_return_val_if_fail (self != NULL, 0);
	if (sigmask != 0) {
		_tmp0_ = (sigover & sigmask) | (sigbase & (~sigmask));
	} else {
		_tmp0_ = sigover;
	}
	result = _tmp0_;
	return result;
}

static void
value_alpm_config_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_alpm_config_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		alpm_config_unref (value->data[0].v_pointer);
	}
}

static void
value_alpm_config_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = alpm_config_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_alpm_config_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_alpm_config_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AlpmConfig * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = alpm_config_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_alpm_config_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	AlpmConfig ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = alpm_config_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_alpm_config (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecAlpmConfig* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ALPM_CONFIG), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_alpm_config (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALPM_CONFIG), NULL);
	return value->data[0].v_pointer;
}

void
value_set_alpm_config (GValue* value,
                       gpointer v_object)
{
	AlpmConfig * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALPM_CONFIG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ALPM_CONFIG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		alpm_config_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alpm_config_unref (old);
	}
}

void
value_take_alpm_config (GValue* value,
                        gpointer v_object)
{
	AlpmConfig * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ALPM_CONFIG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ALPM_CONFIG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alpm_config_unref (old);
	}
}

static void
alpm_config_class_init (AlpmConfigClass * klass,
                        gpointer klass_data)
{
	alpm_config_parent_class = g_type_class_peek_parent (klass);
	((AlpmConfigClass *) klass)->finalize = alpm_config_finalize;
	g_type_class_adjust_private_offset (klass, &AlpmConfig_private_offset);
}

static void
alpm_config_instance_init (AlpmConfig * self,
                           gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	self->priv = alpm_config_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	self->ignorepkgs = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_free0_);
	self->holdpkgs = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, NULL, _g_free0_);
	self->syncfirsts = _tmp8_;
	self->ref_count = 1;
}

static void
alpm_config_finalize (AlpmConfig * obj)
{
	AlpmConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ALPM_CONFIG, AlpmConfig);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->conf_path);
	_g_free0 (self->priv->rootdir);
	_g_free0 (self->dbpath);
	_g_free0 (self->priv->logfile);
	_g_free0 (self->priv->gpgdir);
	_g_free0 (self->priv->download_user);
	_g_ptr_array_unref0 (self->priv->architectures);
	_g_ptr_array_unref0 (self->priv->cachedirs);
	_g_ptr_array_unref0 (self->priv->hookdirs);
	_g_ptr_array_unref0 (self->priv->ignoregroups);
	_g_hash_table_unref0 (self->ignorepkgs);
	_g_ptr_array_unref0 (self->priv->noextracts);
	_g_ptr_array_unref0 (self->priv->noupgrades);
	_g_hash_table_unref0 (self->holdpkgs);
	_g_hash_table_unref0 (self->syncfirsts);
	_g_ptr_array_unref0 (self->priv->repo_order);
}

static GType
alpm_config_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_alpm_config_init, value_alpm_config_free_value, value_alpm_config_copy_value, value_alpm_config_peek_pointer, "p", value_alpm_config_collect_value, "p", value_alpm_config_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AlpmConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alpm_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlpmConfig), 0, (GInstanceInitFunc) alpm_config_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType alpm_config_type_id;
	alpm_config_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AlpmConfig", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AlpmConfig_private_offset = g_type_add_instance_private (alpm_config_type_id, sizeof (AlpmConfigPrivate));
	return alpm_config_type_id;
}

GType
alpm_config_get_type (void)
{
	static volatile gsize alpm_config_type_id__once = 0;
	if (g_once_init_enter (&alpm_config_type_id__once)) {
		GType alpm_config_type_id;
		alpm_config_type_id = alpm_config_get_type_once ();
		g_once_init_leave (&alpm_config_type_id__once, alpm_config_type_id);
	}
	return alpm_config_type_id__once;
}

gpointer
alpm_config_ref (gpointer instance)
{
	AlpmConfig * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
alpm_config_unref (gpointer instance)
{
	AlpmConfig * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALPM_CONFIG_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

